 <?php

/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */

 class DUpload{

	//默认允许上传类型
	public $istype = array(
			'jpg',
			'jpeg',
			'gif',
			'png',
			'bmp',
			'doc'
	);

	//上传文件大小限制，默认-1 为不限制，格式为M
	public $maxSize = -1;

	public $isThumb = false;
	public $thumbWidth = 150;
	public $thumbHeight = 80;

	private $_thumbpath,$_uploadpath;

	private $_files;

	private $_filename;

	public function __construct($params = array())
	{
		$this->istype = empty($params['type']) ?  $this->istype : $params['type'];
		$this->maxSize = empty($params['size']) ?  $this->maxSize : intval($params['size']*(1024*1024));
		$this->isThumb = empty($params['thumb']) ? $this->isThumb : $params['thumb'];
		$this->thumbWidth = empty($params['thumbwidth']) ? $this->thumbWidth : $params['thumbwidth'];
		$this->thumbHeight = empty($params['thumbheight']) ? $this->thumbHeight : $params['thumbheight'];

		$this->_thumbpath = APP_PATH .'File' . DS . 'thumb' . DS . date('Ym');
		$this->_uploadpath = APP_PATH .'File' . DS . 'upload' . DS . date('Ym');

		$this->mkdir();
	}

	private function mkdir()
	{
		$dir = APP_PATH . 'File';

		is_dir($dir) or @mkdir($dir) or DEr::nocite('File目录建立失败, 请手动建立');
		is_dir($dir . DS . 'upload') or @mkdir($dir . DS . 'upload') or DEr::nocite('upload目录建立失败, 请手动建立');
		is_dir($dir . DS . 'thumb') or @mkdir($dir . DS . 'thumb') or DEr::nocite('thumb目录建立失败, 请手动建立');
		is_dir($this->_thumbpath) or @mkdir($this->_thumbpath) or DEr::notice('上传目录建立失败：'.$this->_thumbpath);
		is_dir($this->_uploadpath) or @mkdir($this->_uploadpath) or DEr::notice('上传目录建立失败：'.$this->_uploadpath);
	}
    

	public function save($inputName)
	{
		if(empty($inputName) or empty($_FILES)) return false;
		$this->_files = $_FILES[$inputName];
		$this->checkType();
		$this->checkSize();
		$filename = $this->formatName();
		if(is_array($filename))
		{
			foreach($this->_files['tmp_name'] as $k => $v)
			{
				if(empty($v)) continue;
				@move_uploaded_file($v,$filename[$k]);
			}
		}
		else
		{
			@move_uploaded_file($this->_files['tmp_name'], $filename);
		}
		if($this->isThumb)
		{
			if(is_array($filename))
			{
				foreach($filename as $k => $v)
				{
					if($this->checkThumType($this->_files['type'][$k]))
					{
						$this->_filename['thumb'][$k] = str_replace('/',DS,DuoLam::url()) .'File'. DS .'thumb'. DS. date('Ym') . DS . (time()-rand(time(),5)) . '.jpg';
						$thumbname = $_SERVER['DOCUMENT_ROOT'] . $this->_filename['thumb'][$k];
						DImage::thumb($v,$thumbname,'',$this->thumbWidth,$this->thumbHeight,true);
					}
				}
			}
			else
			{
				if($this->checkThumType($this->_files['type']))
				{	
					$this->_filename['thumb'] = str_replace('/',DS,DuoLam::url()) .'File'. DS .'thumb'. DS. date('Ym') . DS . (time()-rand(time(),5)) . '.jpg';
					$thumbname = $_SERVER['DOCUMENT_ROOT'] . $this->_filename['thumb'];
					DImage::thumb($filename,$thumbname,'',$this->thumbWidth,$this->thumbHeight,true);
				}
			}
		}
		return empty($this->_filename) ? null : $this->_filename;
	}

	private function checkSize()
	{
		$size = 0;
		if($this->maxSize == -1)
		{
			return true;
		}
		else
		{
			if(is_array($this->_files['name']))
			{
				foreach($this->_files['size'] as $v){
					$size += $v;
				}
			}
			else
			{
				$size = $this->_files['size'];
			}
			if($size > $this->maxSize) DEr::notice('上传文件过大!');
		}
	}

	private function formatName()
	{
		if(is_array($this->_files['name']))
		{
			foreach($this->_files['name'] as $k => $v)
			{
				if($v==null) continue;
				$this->_filename['upfile'][$k] = str_replace('/',DS,DuoLam::url()) .'File'. DS .'upload'. DS. date('Ym') . DS . (time()-rand(time(),5)) . strrchr($v,'.');
				$filename[] = $_SERVER['DOCUMENT_ROOT'] . $this->_filename['upfile'][$k];
			}
		}
		else
		{
			if(!empty($this->_files['name']))
			{
				$this->_filename['upfile'] = str_replace('/',DS,DuoLam::url()) .'File'. DS .'upload'. DS. date('Ym') . DS . (time()-rand(time(),5)) . strrchr($this->_files['name'],'.');
				$filename = $_SERVER['DOCUMENT_ROOT'] . $this->_filename['upfile'];
			}
		}
		return empty($filename) ? null : $filename;
	}

	private function checkType()
	{

		if(is_array($this->_files['name']))
		{
			foreach($this->_files['name'] as $v)
			{
				if($v==null) continue;
				$name = strtolower(substr(strrchr($v,'.'),1));
				in_array($name,$this->istype) or DEr::notice('此类型文件不允许上传! 类型:'. $name);
			}
		}
		else
		{
			$name = strtolower(substr(strrchr($this->_files['name'],'.'),1));
			if(!empty($name))
			in_array($name,$this->istype) or DEr::notice('此类型文件不允许上传! 类型:'. $name);
		}
	}

	private function checkThumType($file)
	{
		$type=array('image/jpg','image/jpeg','image/pjpeg','image/gif','image/png','image/bmp','image/x-png');
		return in_array($file,$type) ? true : false;
	}

}
?>